
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
    tomatoes = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="tomatoes")
    cherry_pies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cherry_pies")

    # Set objective function
    m.setObjective(7 * kale_salads + 1 * tomatoes + 5 * cherry_pies, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14 * kale_salads + 9 * tomatoes >= 25, "c0")
    m.addConstr(14 * kale_salads + 1 * cherry_pies >= 29, "c1")
    m.addConstr(14 * kale_salads + 9 * tomatoes + 1 * cherry_pies >= 54, "c2")
    m.addConstr(13 * kale_salads + 10 * tomatoes >= 18, "c3")
    m.addConstr(10 * tomatoes + 9 * cherry_pies >= 30, "c4")
    m.addConstr(13 * kale_salads + 10 * tomatoes + 9 * cherry_pies >= 20, "c5")
    m.addConstr(1 * kale_salads + 1 * cherry_pies >= 18, "c6")
    m.addConstr(1 * kale_salads + 3 * tomatoes >= 33, "c7")
    m.addConstr(1 * kale_salads + 3 * tomatoes + 1 * cherry_pies >= 33, "c8")
    m.addConstr(13 * tomatoes + 2 * cherry_pies >= 12, "c9")
    m.addConstr(7 * kale_salads + 2 * cherry_pies >= 19, "c10")
    m.addConstr(7 * kale_salads + 13 * tomatoes + 2 * cherry_pies >= 19, "c11")
    m.addConstr(-1 * kale_salads + 9 * tomatoes >= 0, "c12")
    m.addConstr(13 * kale_salads + 9 * cherry_pies <= 91, "c13")
    m.addConstr(7 * kale_salads + 2 * cherry_pies <= 51, "c14")
    m.addConstr(13 * tomatoes + 2 * cherry_pies <= 49, "c15")
    m.addConstr(7 * kale_salads + 13 * tomatoes + 2 * cherry_pies <= 38, "c16")

    # Resource Constraints
    m.addConstr(14 * kale_salads + 9 * tomatoes + 1 * cherry_pies <= 198, "carbohydrates")
    m.addConstr(13 * kale_salads + 10 * tomatoes + 9 * cherry_pies <= 95, "tastiness")
    m.addConstr(1 * kale_salads + 3 * tomatoes + 1 * cherry_pies <= 127, "sourness")
    m.addConstr(7 * kale_salads + 13 * tomatoes + 2 * cherry_pies <= 64, "umami")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('kale_salads:', kale_salads.x)
        print('tomatoes:', tomatoes.x)
        print('cherry_pies:', cherry_pies.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
