
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="kale_salads", lb=0, ub=None)  # non-whole number of kale salads
x1 = m.addVar(name="tomatoes", lb=0, ub=None, integrality=1)  # integer amount of tomatoes
x2 = m.addVar(name="cherry_pies", lb=0, ub=None, integrality=1)  # integer amount of cherry pies

# Define the objective function
m.setObjective(7 * x0 + 1 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * x0 + 9 * x1 + 1 * x2 <= 198)
m.addConstr(13 * x0 + 10 * x1 + 9 * x2 <= 95)
m.addConstr(1 * x0 + 3 * x1 + 1 * x2 <= 127)
m.addConstr(7 * x0 + 13 * x1 + 2 * x2 <= 64)
m.addConstr(14 * x0 + 9 * x1 >= 25)
m.addConstr(14 * x0 + 1 * x2 >= 29)
m.addConstr(14 * x0 + 9 * x1 + 1 * x2 >= 54)
m.addConstr(13 * x0 + 10 * x1 >= 18)
m.addConstr(10 * x1 + 9 * x2 >= 30)
m.addConstr(13 * x0 + 10 * x1 + 9 * x2 >= 20)
m.addConstr(1 * x0 + 1 * x2 >= 18)
m.addConstr(1 * x0 + 3 * x1 >= 33)
m.addConstr(1 * x0 + 3 * x1 + 1 * x2 >= 33)
m.addConstr(13 * x1 + 2 * x2 >= 12)
m.addConstr(7 * x0 + 2 * x2 >= 19)
m.addConstr(7 * x0 + 13 * x1 + 2 * x2 >= 19)
m.addConstr(-1 * x0 + 9 * x1 >= 0)
m.addConstr(13 * x0 + 9 * x2 <= 91)
m.addConstr(7 * x0 + 2 * x2 <= 51)
m.addConstr(13 * x1 + 2 * x2 <= 49)
m.addConstr(7 * x0 + 13 * x1 + 2 * x2 <= 38)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Kale Salads: ", x0.varValue)
    print("Tomatoes: ", x1.varValue)
    print("Cherry Pies: ", x2.varValue)
else:
    print("The model is infeasible")
