
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")


# Set objective function
m.setObjective(5.02 * jean + 3.45 * john + 6.23 * dale + 5.24 * peggy, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * jean + 3 * john + 5 * peggy >= 16)
m.addConstr(2 * jean + 3 * dale + 5 * peggy >= 16)
m.addConstr(3 * john + 3 * dale + 5 * peggy >= 16)
m.addConstr(2 * jean + 3 * john + 5 * peggy >= 10)
m.addConstr(2 * jean + 3 * dale + 5 * peggy >= 10)
m.addConstr(3 * john + 3 * dale + 5 * peggy >= 10)
m.addConstr(2 * jean + 3 * john + 5 * peggy >= 12)
m.addConstr(2 * jean + 3 * dale + 5 * peggy >= 12)
m.addConstr(3 * john + 3 * dale + 5 * peggy >= 12)
m.addConstr(5 * jean + 1 * peggy >= 7)
m.addConstr(5 * jean + 5 * john + 1 * dale >= 16)
m.addConstr(3 * john + 3 * dale <= 54)
m.addConstr(2 * jean + 5 * peggy <= 41)
m.addConstr(2 * jean + 3 * john + 5 * peggy <= 47)
m.addConstr(3 * john + 3 * dale + 5 * peggy <= 43)
m.addConstr(2 * jean + 3 * dale + 5 * peggy <= 32)
m.addConstr(2 * jean + 3 * john + 3 * dale + 5 * peggy <= 32)
m.addConstr(5 * jean + 1 * peggy <= 54)
m.addConstr(5 * jean + 5 * john <= 53)
m.addConstr(5 * john + 1 * dale <= 18)
m.addConstr(5 * john + 1 * dale + 1 * peggy <= 23)
m.addConstr(5 * jean + 5 * john + 1 * dale <= 52)
m.addConstr(5 * jean + 5 * john + 1 * dale + 1 * peggy <= 52)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

