
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0)  # hours worked by Jean
x1 = m.addVar(name='x1', lb=0)  # hours worked by John
x2 = m.addVar(name='x2', lb=0)  # hours worked by Dale
x3 = m.addVar(name='x3', lb=0)  # hours worked by Peggy

# Define the objective function
m.setObjective(5.02*x0 + 3.45*x1 + 6.23*x2 + 5.24*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 3*x1 + 5*x3 >= 16)
m.addConstr(2*x0 + 3*x2 + 5*x3 >= 16)
m.addConstr(3*x1 + 3*x2 + 5*x3 >= 16)
m.addConstr(2*x0 + 3*x1 + 5*x3 >= 10)
m.addConstr(2*x0 + 3*x2 + 5*x3 >= 10)
m.addConstr(3*x1 + 3*x2 + 5*x3 >= 10)
m.addConstr(2*x0 + 3*x1 + 5*x3 >= 12)
m.addConstr(2*x0 + 3*x2 + 5*x3 >= 12)
m.addConstr(3*x1 + 3*x2 + 5*x3 >= 12)
m.addConstr(5*x0 + x3 >= 7)
m.addConstr(5*x0 + 5*x1 + x2 >= 16)
m.addConstr(3*x1 + 3*x2 <= 54)
m.addConstr(2*x0 + 5*x3 <= 41)
m.addConstr(2*x0 + 3*x1 + 5*x3 <= 47)
m.addConstr(3*x1 + 3*x2 + 5*x3 <= 43)
m.addConstr(2*x0 + 3*x2 + 5*x3 <= 32)
m.addConstr(2*x0 + 3*x1 + 3*x2 + 5*x3 <= 32)
m.addConstr(5*x0 + x3 <= 54)
m.addConstr(5*x0 + 5*x1 <= 53)
m.addConstr(5*x1 + x2 <= 18)
m.addConstr(5*x1 + x2 + x3 <= 23)
m.addConstr(5*x0 + 5*x1 + x2 <= 52)
m.addConstr(5*x0 + 5*x1 + x2 + x3 <= 52)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Jean: ', x0.varValue)
    print('Hours worked by John: ', x1.varValue)
    print('Hours worked by Dale: ', x2.varValue)
    print('Hours worked by Peggy: ', x3.varValue)
else:
    print('No solution found')
