
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")


# Set objective function
m.setObjective(3 * fruit_salads + 3 * hamburgers + 1 * kiwis + 9 * chicken_thighs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.59 * fruit_salads + 7.89 * kiwis >= 10)
m.addConstr(1.36 * hamburgers + 1.43 * chicken_thighs >= 18)
m.addConstr(7.89 * kiwis + 1.43 * chicken_thighs >= 10)
m.addConstr(5.59 * fruit_salads + 7.89 * kiwis + 1.43 * chicken_thighs >= 27)
m.addConstr(5.59 * fruit_salads + 1.36 * hamburgers + 7.89 * kiwis + 1.43 * chicken_thighs >= 27)
m.addConstr(6.73 * hamburgers + 5.21 * kiwis >= 24)
m.addConstr(4.03 * fruit_salads + 6.73 * hamburgers >= 18)
m.addConstr(6.73 * hamburgers + 7.13 * chicken_thighs >= 12)
m.addConstr(4.03 * fruit_salads + 7.13 * chicken_thighs >= 12)
m.addConstr(4.03 * fruit_salads + 6.73 * hamburgers + 5.21 * kiwis + 7.13 * chicken_thighs >= 12)
m.addConstr(9 * fruit_salads - 8 * kiwis >= 0)
m.addConstr(-4 * hamburgers + 10 * kiwis >= 0)
m.addConstr(5.59 * fruit_salads + 1.43 * chicken_thighs <= 96)
m.addConstr(1.36 * hamburgers + 7.89 * kiwis <= 39)
m.addConstr(1.36 * hamburgers + 1.43 * chicken_thighs <= 98)
m.addConstr(5.59 * fruit_salads + 1.36 * hamburgers + 1.43 * chicken_thighs <= 67)
m.addConstr(4.03 * fruit_salads + 7.13 * chicken_thighs <= 41)
m.addConstr(6.73 * hamburgers + 7.13 * chicken_thighs <= 122)
m.addConstr(6.73 * hamburgers + 5.21 * kiwis + 7.13 * chicken_thighs <= 75)
m.addConstr(4.03 * fruit_salads + 6.73 * hamburgers + 7.13 * chicken_thighs <= 99)
m.addConstr(4.03 * fruit_salads + 5.21 * kiwis + 7.13 * chicken_thighs <= 87)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

