
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
vitamin_b4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")

# Set objective function
m.setObjective(7 * carbohydrates + 1 * vitamin_b4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * carbohydrates + 8 * vitamin_b4 >= 12, "immune_support_min")
m.addConstr(1 * carbohydrates + 1 * vitamin_b4 >= 13, "cognitive_performance_min")
m.addConstr(6 * carbohydrates - 3 * vitamin_b4 >= 0, "carbohydrate_vitamin_ratio")
m.addConstr(4 * carbohydrates + 8 * vitamin_b4 <= 36, "immune_support_max")
m.addConstr(1 * carbohydrates + 1 * vitamin_b4 <= 16, "cognitive_performance_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Grams of carbohydrates: {carbohydrates.x}")
    print(f"Milligrams of vitamin B4: {vitamin_b4.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

