
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(name="grams_of_carbohydrates", lb=-GRB.INFINITY, ub=GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_B4", lb=-GRB.INFINITY, ub=GRB.INFINITY)

# Set the objective function
m.setObjective(7*x0 + x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 8*x1 >= 12, name="immune_support_index_min")
m.addConstr(x0 + x1 >= 13, name="cognitive_performance_index_min")
m.addConstr(6*x0 - 3*x1 >= 0, name="carbohydrates_vitamin_b4_constraint")
m.addConstr(4*x0 + 8*x1 <= 36, name="immune_support_index_max")
m.addConstr(x0 + x1 <= 16, name="cognitive_performance_index_max")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of carbohydrates: {x0.x}")
    print(f"Milligrams of vitamin B4: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
