
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_carbohydrates", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="milligrams_of_vitamin_B4", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(7 * x1 + x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x1 + 8 * x2 >= 12, name="immune_support_min")
    model.addConstr(x1 + x2 >= 13, name="cognitive_performance_min")
    model.addConstr(6 * x1 - 3 * x2 >= 0, name="carbohydrates_vitamin_B4_relation")
    model.addConstr(4 * x1 + 8 * x2 <= 36, name="immune_support_max")
    model.addConstr(x1 + x2 <= 16, name="cognitive_performance_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of carbohydrates: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
