
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("supplement_optimization")

    # Create variables
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")


    # Set objective function
    m.setObjective(7 * vitamin_d + 5 * zinc + 1 * magnesium, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * vitamin_d + 6 * zinc + 6 * magnesium <= 66, "kidney_support_limit")
    m.addConstr(8 * vitamin_d + 1 * zinc + 11 * magnesium <= 161, "cognitive_performance_limit")
    m.addConstr(8 * vitamin_d + 14 * zinc + 12 * magnesium <= 180, "energy_stability_limit")
    m.addConstr(1 * vitamin_d + 8 * zinc + 11 * magnesium <= 217, "muscle_growth_limit")

    m.addConstr(3 * vitamin_d + 6 * magnesium >= 9, "kidney_support_vd_mg_min")
    m.addConstr(6 * zinc + 6 * magnesium >= 18, "kidney_support_zn_mg_min")
    m.addConstr(1 * vitamin_d + 11 * magnesium >= 57, "muscle_growth_vd_mg_min")
    m.addConstr(6 * zinc + 6 * magnesium <= 51, "kidney_support_zn_mg_max")
    m.addConstr(3 * vitamin_d + 6 * zinc + 6 * magnesium <= 57, "kidney_support_total_max1")  # Redundant due to next constraint
    m.addConstr(3 * vitamin_d + 6 * zinc + 6 * magnesium == 57, "kidney_support_total_max2")
    m.addConstr(8 * vitamin_d + 1 * zinc <= 113, "cognitive_performance_vd_zn_max")
    m.addConstr(1 * zinc + 11 * magnesium <= 109, "cognitive_performance_zn_mg_max")
    m.addConstr(8 * vitamin_d + 1 * zinc + 11 * magnesium <= 109, "cognitive_performance_total_max")
    m.addConstr(8 * vitamin_d + 14 * zinc <= 119, "energy_stability_vd_zn_max")
    m.addConstr(8 * vitamin_d + 14 * zinc + 12 * magnesium <= 119, "energy_stability_total_max")
    m.addConstr(1 * vitamin_d + 11 * magnesium <= 87, "muscle_growth_vd_mg_max")
    m.addConstr(8 * zinc + 11 * magnesium <= 159, "muscle_growth_zn_mg_max")
    m.addConstr(1 * vitamin_d + 8 * zinc + 11 * magnesium <= 159, "muscle_growth_total_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_d:', vitamin_d.x)
        print('zinc:', zinc.x)
        print('magnesium:', magnesium.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
