
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin D")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of zinc")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of magnesium")

    # Objective function
    model.setObjective(7*x0 + 5*x1 + x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 >= 3, name="kidney_support_index_x0")
    model.addConstr(6*x1 + 6*x2 >= 18, name="kidney_support_index_x1_x2")
    model.addConstr(x0 + 11*x2 >= 57, name="muscle_growth_index_x0_x2")
    model.addConstr(6*x1 + 6*x2 <= 51, name="kidney_support_index_x1_x2_upper")
    model.addConstr(3*x0 + 6*x1 + 6*x2 <= 57, name="kidney_support_index_all")
    model.addConstr(8*x0 + x1 <= 113, name="cognitive_performance_index_x0_x1")
    model.addConstr(x1 + 11*x2 <= 109, name="cognitive_performance_index_x1_x2")
    model.addConstr(8*x0 + x1 + 11*x2 <= 109, name="cognitive_performance_index_all")
    model.addConstr(8*x0 + 14*x1 <= 119, name="energy_stability_index_x0_x1")
    model.addConstr(8*x0 + 14*x1 + 12*x2 <= 119, name="energy_stability_index_all")
    model.addConstr(x0 + 11*x2 <= 87, name="muscle_growth_index_x0_x2_upper")
    model.addConstr(8*x1 + 11*x2 <= 159, name="muscle_growth_index_x1_x2")
    model.addConstr(x0 + 8*x1 + 11*x2 <= 159, name="muscle_growth_index_all")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Milligrams of zinc: {x1.varValue}")
        print(f"Milligrams of magnesium: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
