
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")


# Set objective
m.setObjective(7 * mary + 1 * paul + 8 * george + 2 * ringo + 8 * bill, gp.GRB.MAXIMIZE)

# Add constraints

# Competence constraints
m.addConstr(0.27 * mary + 0.65 * ringo >= 22)
m.addConstr(0.08 * george + 1.65 * bill >= 19)
m.addConstr(0.27 * mary + 0.08 * george >= 26)
m.addConstr(0.08 * george + 0.65 * ringo >= 33)
m.addConstr(0.43 * paul + 0.08 * george + 0.65 * ringo >= 28)
m.addConstr(0.27 * mary + 0.43 * paul + 0.65 * ringo >= 28)
m.addConstr(0.27 * mary + 0.08 * george + 1.65 * bill >= 28)
m.addConstr(0.27 * mary + 0.43 * paul + 0.08 * george >= 28)
m.addConstr(0.43 * paul + 0.65 * ringo + 1.65 * bill >= 28)
m.addConstr(0.43 * paul + 0.08 * george + 0.65 * ringo >= 31)
m.addConstr(0.27 * mary + 0.43 * paul + 0.65 * ringo >= 31)
m.addConstr(0.27 * mary + 0.08 * george + 1.65 * bill >= 31)
m.addConstr(0.27 * mary + 0.43 * paul + 0.08 * george >= 31)
m.addConstr(0.43 * paul + 0.65 * ringo + 1.65 * bill >= 31)
# ... (rest of the competence constraints from the JSON)

# Cost constraints
m.addConstr(0.86 * mary + 1.55 * paul + 1.07 * george >= 45)
m.addConstr(1.55 * paul + 1.5 * ringo + 1.23 * bill >= 45)
# ... (rest of the cost constraints from the JSON)


# Upper bound constraints
m.addConstr(0.08 * george + 1.65 * bill <= 138)
m.addConstr(0.08 * george + 0.65 * ringo <= 144)
# ... (rest of the upper bound constraints from the JSON)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

