
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
    x3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")


    # Set objective function
    model.setObjective(8*x0**2 + 8*x0*x1 + 9*x0*x2 + 2*x0*x3 + 7*x1*x2 + 6*x1*x3 + 3*x2**2 + 6*x3**2 + 3*x0 + 3*x1 + 2*x3, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 10*x3 >= 32, "c0")
    model.addConstr(7*x0 + 4*x1 >= 28, "c1")
    model.addConstr(4*x1 + 8*x2 >= 49, "c2")
    model.addConstr(8*x2 + 10*x3 >= 41, "c3")
    model.addConstr(7*x0 + 4*x1 + 10*x3 >= 55, "c4")
    model.addConstr(7*x0 + 4*x1 + 8*x2 + 10*x3 >= 55, "c5")
    model.addConstr(-5*x0 + 5*x2 >= 0, "c6")
    model.addConstr(4*x1**2 + 8*x2**2 + 10*x3**2 <= 79, "c7")
    model.addConstr(7*x0 + 8*x2 + 10*x3 <= 179, "c8")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
