
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_John", lb=0)
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)
x3 = m.addVar(name="hours_worked_by_Laura", lb=0)
x4 = m.addVar(name="hours_worked_by_Jean", lb=0)

# Objective function
m.setObjective(8*x1**2 + 8*x1*x2 + 9*x1*x3 + 2*x1*x4 + 7*x2*x3 + 6*x2*x4 + 3*x3**2 + 6*x4**2 + 3*x1 + 3*x2 + 2*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(7*x1 <= 221)
m.addConstr(4*x2 <= 221)
m.addConstr(8*x3 <= 221)
m.addConstr(10*x4 <= 221)
m.addConstr(4*x2 + 10*x4 >= 32)
m.addConstr(7*x1 + 4*x2 >= 28)
m.addConstr(4*x2 + 8*x3 >= 49)
m.addConstr(8*x3 + 10*x4 >= 41)
m.addConstr(7*x1 + 4*x2 + 10*x4 >= 55)
m.addConstr(7*x1 + 4*x2 + 8*x3 + 10*x4 >= 55)
m.addConstr(-5*x1 + 5*x3 >= 0)
m.addConstr(16*x2**2 + 64*x3**2 + 100*x4**2 <= 79)
m.addConstr(7*x1 + 8*x3 + 10*x4 <= 179)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by Laura: ", x3.varValue)
    print("Hours worked by Jean: ", x4.varValue)
else:
    print("The model is infeasible")
