
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by John
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Peggy
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Jean
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by George


    # Set objective function
    m.setObjective(5.05 * x0 + 4.75 * x1 + 1.38 * x2 + 7.87 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4.91 * x0 + 5.85 * x1 >= 28)
    m.addConstr(5.85 * x1 + 2.25 * x3 >= 29)
    m.addConstr(4.91 * x0 + 5.85 * x1 + 2.25 * x3 >= 31)
    m.addConstr(4.91 * x0 + 1.24 * x2 + 2.25 * x3 >= 31)
    m.addConstr(4.91 * x0 + 5.85 * x1 + 2.25 * x3 >= 42)
    m.addConstr(4.91 * x0 + 1.24 * x2 + 2.25 * x3 >= 42)
    m.addConstr(4.91 * x0 + 5.85 * x1 + 1.24 * x2 + 2.25 * x3 >= 42)
    m.addConstr(10.31 * x0 + 6.4 * x1 >= 45)
    m.addConstr(10.31 * x0 + 10.0 * x3 >= 71)
    m.addConstr(10.31 * x0 + 6.78 * x2 >= 76)
    m.addConstr(6.4 * x1 + 10.0 * x3 >= 85)
    m.addConstr(10.31 * x0 + 6.4 * x1 + 6.78 * x2 >= 64)
    m.addConstr(10.31 * x0 + 6.4 * x1 + 6.78 * x2 + 10.0 * x3 >= 64)
    m.addConstr(1.59 * x1 + 4.43 * x2 >= 38)
    m.addConstr(1.41 * x0 + 4.43 * x2 >= 42)
    m.addConstr(1.59 * x1 + 7.5 * x3 >= 42)
    m.addConstr(1.41 * x0 + 1.59 * x1 + 4.43 * x2 >= 45)
    m.addConstr(1.41 * x0 + 1.59 * x1 + 4.43 * x2 + 7.5 * x3 >= 45)
    m.addConstr(-4 * x1 + 9 * x2 >= 0)
    m.addConstr(10 * x0 - 8 * x1 >= 0)
    m.addConstr(4 * x1 - 9 * x3 >= 0)
    m.addConstr(5.85 * x1 + 1.24 * x2 <= 89)
    m.addConstr(4.91 * x0 + 5.85 * x1 <= 157)
    m.addConstr(4.91 * x0 + 2.25 * x3 <= 140)
    m.addConstr(6.78 * x2 + 10.0 * x3 <= 219)
    m.addConstr(10.31 * x0 + 6.78 * x2 <= 101)
    m.addConstr(10.31 * x0 + 10.0 * x3 <= 274)
    m.addConstr(6.4 * x1 + 10.0 * x3 <= 165)
    m.addConstr(6.4 * x1 + 6.78 * x2 <= 176)
    m.addConstr(10.31 * x0 + 6.4 * x1 + 10.0 * x3 <= 88)
    m.addConstr(1.41 * x0 + 4.43 * x2 <= 145)
    m.addConstr(1.41 * x0 + 1.59 * x1 <= 54)
    m.addConstr(4.43 * x2 + 7.5 * x3 <= 125)
    m.addConstr(1.59 * x1 + 7.5 * x3 <= 158)
    m.addConstr(1.59 * x1 + 4.43 * x2 <= 64)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
