
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, names=["protein bars", "lemons", "blueberry pies", "peanutbutter sandwiches", "sashimi"])


# Set objective function
m.setObjective(3.67 * x[0] + 4.72 * x[1] + 8.41 * x[2] + 9.9 * x[3] + 4.04 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.4 * x[0] + 0.8 * x[1] + 1.18 * x[2] + 1.55 * x[3] + 1.17 * x[4] <= 369, "r0")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.29 * x[2] + 0.33 * x[3] + 2.27 * x[4] <= 721, "r1")
m.addConstr(0.3 * x[0] + 0.81 * x[1] + 1.75 * x[2] + 2.36 * x[3] + 1.97 * x[4] <= 407, "r2")
m.addConstr(0.8 * x[1] + 1.55 * x[3] >= 47, "c1")
m.addConstr(1.55 * x[3] + 1.17 * x[4] >= 27, "c2")
m.addConstr(0.8 * x[1] + 1.18 * x[2] + 1.17 * x[4] >= 58, "c3")
m.addConstr(1.4 * x[0] + 1.55 * x[3] + 1.17 * x[4] >= 58, "c4")
m.addConstr(0.8 * x[1] + 1.18 * x[2] + 1.17 * x[4] >= 40, "c5")
m.addConstr(1.4 * x[0] + 1.55 * x[3] + 1.17 * x[4] >= 40, "c6")


#Fat Constraints
m.addConstr(1.6 * x[0] + 0.29 * x[2] >= 137, "c7")
m.addConstr(1.6 * x[0] + 0.33 * x[3] >= 69, "c8")
m.addConstr(1.4 * x[1] + 0.33 * x[3] >= 100, "c9")
m.addConstr(1.4 * x[1] + 0.29 * x[2] >= 60, "c10")
m.addConstr(1.4 * x[1] + 0.33 * x[3] + 2.27 * x[4] >= 126, "c11")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.33 * x[3] >= 126, "c12")
m.addConstr(1.4 * x[1] + 0.29 * x[2] + 2.27 * x[4] >= 126, "c13")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 2.27 * x[4] >= 126, "c14")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 0.33 * x[3] >= 126, "c15")
m.addConstr(1.4 * x[1] + 0.33 * x[3] + 2.27 * x[4] >= 106, "c16")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.33 * x[3] >= 106, "c17")
m.addConstr(1.4 * x[1] + 0.29 * x[2] + 2.27 * x[4] >= 106, "c18")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 2.27 * x[4] >= 106, "c19")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 0.33 * x[3] >= 106, "c20")
m.addConstr(1.4 * x[1] + 0.33 * x[3] + 2.27 * x[4] >= 130, "c21")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.33 * x[3] >= 130, "c22")
m.addConstr(1.4 * x[1] + 0.29 * x[2] + 2.27 * x[4] >= 130, "c23")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 2.27 * x[4] >= 130, "c24")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 0.33 * x[3] >= 130, "c25")
m.addConstr(1.4 * x[1] + 0.33 * x[3] + 2.27 * x[4] >= 140, "c26")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.33 * x[3] >= 140, "c27")
m.addConstr(1.4 * x[1] + 0.29 * x[2] + 2.27 * x[4] >= 140, "c28")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 2.27 * x[4] >= 140, "c29")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 0.33 * x[3] >= 140, "c30")
m.addConstr(1.4 * x[1] + 0.33 * x[3] + 2.27 * x[4] >= 96, "c31")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.33 * x[3] >= 96, "c32")
m.addConstr(1.4 * x[1] + 0.29 * x[2] + 2.27 * x[4] >= 96, "c33")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 2.27 * x[4] >= 96, "c34")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 0.33 * x[3] >= 96, "c35")


# Cost Constraints
m.addConstr(0.81 * x[1] + 1.75 * x[2] >= 46, "c36")
m.addConstr(0.3 * x[0] + 0.81 * x[1] >= 41, "c37")
m.addConstr(0.3 * x[0] + 1.75 * x[2] >= 36, "c38")
m.addConstr(0.81 * x[1] + 1.97 * x[4] >= 79, "c39")
m.addConstr(0.3 * x[0] + 2.36 * x[3] >= 52, "c40")
m.addConstr(1.75 * x[2] + 1.97 * x[4] >= 61, "c41")
m.addConstr(0.81 * x[1] + 1.75 * x[2] + 1.97 * x[4] >= 64, "c42")

# Sourness Upper Bound Constraints
m.addConstr(1.4 * x[0] + 0.8 * x[1] <= 196, "c43")
m.addConstr(1.4 * x[0] + 1.55 * x[3] <= 143, "c44")
m.addConstr(0.8 * x[1] + 1.55 * x[3] <= 266, "c45")
m.addConstr(0.8 * x[1] + 1.17 * x[4] <= 200, "c46")
m.addConstr(0.8 * x[1] + 1.18 * x[2] <= 321, "c47")
m.addConstr(1.4 * x[0] + 1.17 * x[4] <= 282, "c48")
m.addConstr(1.18 * x[2] + 1.17 * x[4] <= 176, "c49")
m.addConstr(1.4 * x[0] + 1.55 * x[3] + 1.17 * x[4] <= 148, "c50")
m.addConstr(1.18 * x[2] + 1.55 * x[3] + 1.17 * x[4] <= 312, "c51")
m.addConstr(1.4 * x[0] + 0.8 * x[1] + 1.18 * x[2] + 1.55 * x[3] + 1.17 * x[4] <= 312, "c52")

# Fat Upper Bound Constraints
m.addConstr(1.6 * x[0] + 0.33 * x[3] <= 518, "c53")
m.addConstr(1.4 * x[1] + 0.29 * x[2] <= 242, "c54")
m.addConstr(0.29 * x[2] + 0.33 * x[3] <= 424, "c55")
m.addConstr(0.33 * x[3] + 2.27 * x[4] <= 686, "c56")
m.addConstr(1.4 * x[1] + 2.27 * x[4] <= 210, "c57")
m.addConstr(1.4 * x[1] + 0.33 * x[3] <= 685, "c58")
m.addConstr(1.6 * x[0] + 0.29 * x[2] + 2.27 * x[4] <= 156, "c59")
m.addConstr(1.6 * x[0] + 1.4 * x[1] + 0.29 * x[2] + 0.33 * x[3] + 2.27 * x[4] <= 156, "c60")

# Cost Upper Bound Constraints
m.addConstr(1.75 * x[2] + 1.97 * x[4] <= 150, "c61")
m.addConstr(0.81 * x[1] + 1.97 * x[4] <= 363, "c62")
m.addConstr(0.3 * x[0] + 1.97 * x[4] <= 195, "c63")
m.addConstr(1.75 * x[2] + 2.36 * x[3] <= 391, "c64")
m.addConstr(0.81 * x[1] + 1.75 * x[2] <= 352, "c65")
m.addConstr(0.3 * x[0] + 2.36 * x[3] <= 353, "c66")
m.addConstr(0.81 * x[1] + 2.36 * x[3] <= 220, "c67")
m.addConstr(0.3 * x[0] + 0.81 * x[1] <= 269, "c68")
m.addConstr(0.3 * x[0] + 0.81 * x[1] + 2.36 * x[3] <= 269, "c69")
m.addConstr(0.3 * x[0] + 1.75 * x[2] + 2.36 * x[3] <= 267, "c70")
m.addConstr(0.3 * x[0] + 0.81 * x[1] + 1.75 * x[2] + 2.36 * x[3] + 1.97 * x[4] <= 267, "c71")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

