
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="candles")


    # Set objective function
    model.setObjective(6.32 * x0 + 6.34 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x0 + 9 * x1 >= 54, "c1")
    model.addConstr(15 * x0 + 17 * x1 >= 55, "c2")
    model.addConstr(4 * x0 - 3 * x1 >= 0, "c3")
    model.addConstr(4 * x0 + 9 * x1 <= 178, "c4")
    model.addConstr(15 * x0 + 17 * x1 <= 86, "c5")
    
    # Add non-negativity constraints explicitly for integer variables
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("paper_towel_rolls:", x0.x)
        print("candles:", x1.x)

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized successfully.")

