
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
x2 = m.addVar(vtype=GRB.INTEGER, name="candles")

# Set the objective function
m.setObjective(6.32*x1 + 6.34*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 9*x2 >= 54, "portability_min")
m.addConstr(15*x1 + 17*x2 >= 55, "usefulness_min")
m.addConstr(4*x1 - 3*x2 >= 0, "mixed_constraint")
m.addConstr(4*x1 + 9*x2 <= 178, "portability_max")
m.addConstr(15*x1 + 17*x2 <= 86, "usefulness_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Paper towel rolls: {x1.x}")
    print(f"Candles: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
