
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="candles", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(6.32 * x1 + 6.34 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(4 * x1 + 9 * x2 >= 54)
model.addConstr(15 * x1 + 17 * x2 >= 55)
model.addConstr(4 * x1 - 3 * x2 >= 0)
model.addConstr(4 * x1 + 9 * x2 <= 178)
model.addConstr(15 * x1 + 17 * x2 <= 86)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Paper towel rolls: {x1.varValue}")
    print(f"Candles: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
