
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(3*x0 + 8*x1 + 7*x2 + 6*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 4*x1 + 4*x2 + 5*x3 <= 108)
    m.addConstr(2*x0 + 4*x1 + 1*x2 + 4*x3 <= 84)
    m.addConstr(5*x0 + 4*x1 + 3*x2 + 4*x3 <= 79)
    m.addConstr(5*x0 + 1*x1 + 2*x2 + 5*x3 <= 58)
    m.addConstr(4*x2 + 5*x3 >= 13)
    m.addConstr(3*x0 + 5*x3 >= 25)
    m.addConstr(3*x0 + 4*x2 >= 27)
    m.addConstr(3*x0 + 4*x1 + 5*x3 >= 26)
    m.addConstr(3*x0 + 4*x1 + 4*x2 >= 26)
    m.addConstr(4*x1 + 4*x2 + 5*x3 >= 26)
    m.addConstr(3*x0 + 4*x1 + 5*x3 >= 21)
    m.addConstr(3*x0 + 4*x1 + 4*x2 >= 21)
    m.addConstr(4*x1 + 4*x2 + 5*x3 >= 21)
    m.addConstr(3*x0 + 4*x1 + 5*x3 >= 15)
    m.addConstr(3*x0 + 4*x1 + 4*x2 >= 15)
    m.addConstr(4*x1 + 4*x2 + 5*x3 >= 15)
    m.addConstr(3*x0 + 4*x1 + 4*x2 + 5*x3 >= 15)
    m.addConstr(4*x1 + 4*x3 >= 15)
    m.addConstr(1*x2 + 4*x3 >= 18)
    m.addConstr(2*x0 + 4*x1 >= 21)
    m.addConstr(2*x0 + 4*x1 + 1*x2 + 4*x3 >= 21)
    m.addConstr(5*x0 + 4*x3 >= 15)
    m.addConstr(3*x2 + 4*x3 >= 14)
    m.addConstr(4*x1 + 3*x2 >= 13)
    m.addConstr(5*x0 + 4*x1 + 3*x2 + 4*x3 >= 13)
    m.addConstr(1*x1 + 5*x3 >= 8)
    m.addConstr(5*x0 + 1*x1 >= 11)
    m.addConstr(5*x0 + 1*x1 + 2*x2 + 5*x3 >= 11)
    m.addConstr(-2*x2 + 5*x3 >= 0)
    m.addConstr(2*x1 - 2*x2 >= 0)
    m.addConstr(4*x1 + 5*x3 <= 67)
    m.addConstr(3*x0 + 4*x1 <= 28)
    m.addConstr(4*x1 + 4*x2 <= 104)
    m.addConstr(2*x0 + 1*x2 <= 65)
    m.addConstr(1*x2 + 4*x3 <= 77)
    m.addConstr(4*x1 + 1*x2 <= 83)
    m.addConstr(2*x0 + 4*x1 <= 35)
    m.addConstr(2*x0 + 4*x1 + 4*x3 <= 72)
    m.addConstr(2*x0 + 1*x2 + 4*x3 <= 27)
    m.addConstr(2*x0 + 4*x1 + 1*x2 <= 57)
    m.addConstr(4*x1 + 1*x2 + 4*x3 <= 44)
    m.addConstr(1*x1 + 5*x3 <= 42)
    m.addConstr(1*x1 + 2*x2 <= 29)
    m.addConstr(5*x0 + 1*x1 <= 47)
    m.addConstr(1*x1 + 2*x2 + 5*x3 <= 41)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
