
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # milligrams of vitamin B1
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # grams of protein
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin B6
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin C

    # Objective function
    model.setObjective(3*x0 + 8*x1 + 7*x2 + 6*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x0 <= 108)
    model.addConstr(2*x0 <= 84)
    model.addConstr(5*x0 <= 79)
    model.addConstr(5*x0 <= 58)
    model.addConstr(4*x1 <= 108)
    model.addConstr(4*x1 <= 84)
    model.addConstr(4*x1 <= 79)
    model.addConstr(x1 <= 58)
    model.addConstr(4*x2 <= 108)
    model.addConstr(x2 <= 84)
    model.addConstr(3*x2 <= 79)
    model.addConstr(2*x2 <= 58)
    model.addConstr(5*x3 <= 108)
    model.addConstr(4*x3 <= 84)
    model.addConstr(4*x3 <= 79)
    model.addConstr(5*x3 <= 58)
    model.addConstr(4*x2 + 5*x3 >= 13)
    model.addConstr(3*x0 + 5*x3 >= 25)
    model.addConstr(3*x0 + 4*x2 >= 27)
    model.addConstr(3*x0 + 4*x1 + 5*x3 >= 26)
    model.addConstr(3*x0 + 4*x1 + 4*x2 >= 26)
    model.addConstr(4*x1 + 4*x2 + 5*x3 >= 26)
    model.addConstr(3*x0 + 4*x1 + 5*x3 >= 21)
    model.addConstr(3*x0 + 4*x1 + 4*x2 >= 21)
    model.addConstr(4*x1 + 4*x2 + 5*x3 >= 21)
    model.addConstr(3*x0 + 4*x1 + 5*x3 >= 15)
    model.addConstr(3*x0 + 4*x1 + 4*x2 >= 15)
    model.addConstr(4*x1 + 4*x2 + 5*x3 >= 15)
    model.addConstr(3*x0 + 4*x1 + 4*x2 + 5*x3 >= 15)
    model.addConstr(4*x1 + 4*x3 >= 15)
    model.addConstr(x2 + 4*x3 >= 18)
    model.addConstr(2*x0 + 4*x1 >= 21)
    model.addConstr(2*x0 + 4*x1 + x2 + 4*x3 >= 21)
    model.addConstr(5*x0 + 4*x3 >= 15)
    model.addConstr(x2 + 4*x3 >= 14)
    model.addConstr(4*x1 + x2 >= 13)
    model.addConstr(5*x0 + 4*x1 + x2 + 4*x3 >= 13)
    model.addConstr(x1 + 5*x3 >= 8)
    model.addConstr(5*x0 + 4*x1 >= 11)
    model.addConstr(5*x0 + 4*x1 + x2 + 5*x3 >= 11)
    model.addConstr(-2*x2 + 5*x3 >= 0)
    model.addConstr(2*x1 - 2*x2 >= 0)
    model.addConstr(4*x1 + 5*x3 <= 67)
    model.addConstr(3*x0 + 4*x1 <= 28)
    model.addConstr(4*x1 + x2 <= 104)
    model.addConstr(2*x0 + x2 <= 65)
    model.addConstr(x2 + 4*x3 <= 77)
    model.addConstr(4*x1 + x2 <= 83)
    model.addConstr(2*x0 + 4*x1 <= 35)
    model.addConstr(2*x0 + 4*x1 + 4*x3 <= 72)
    model.addConstr(2*x0 + x2 + 4*x3 <= 27)
    model.addConstr(2*x0 + 4*x1 + x2 <= 57)
    model.addConstr(4*x1 + x2 + 5*x3 <= 44)
    model.addConstr(x1 + 5*x3 <= 42)
    model.addConstr(x1 + x2 <= 29)
    model.addConstr(5*x0 + 4*x1 <= 47)
    model.addConstr(x1 + x2 + 5*x3 <= 41)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
