
import gurobipy as gp

# Create a new model
m = gp.Model("military_optimization")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="armored_companies")


# Set objective function
m.setObjective(6*x0 + 3*x1 + 5*x2 + 4*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 5*x1 >= 9)
m.addConstr(5*x1 + 3*x2 >= 14)
m.addConstr(4*x0 + 5*x1 >= 9)
m.addConstr(3*x2 + 4*x3 >= 9)
m.addConstr(5*x1 + 4*x3 >= 11)
m.addConstr(3*x2 + 4*x3 <= 21)
m.addConstr(3*x0 + 4*x3 <= 29)
m.addConstr(5*x1 + 4*x3 <= 22)
m.addConstr(3*x0 + 5*x1 + 3*x2 + 4*x3 <= 22)
m.addConstr(5*x1 + 4*x3 <= 17)
m.addConstr(3*x2 + 4*x3 <= 28)
m.addConstr(4*x0 + 4*x3 <= 28)
m.addConstr(4*x0 + 5*x1 <= 45)
m.addConstr(4*x0 + 3*x2 <= 55)
m.addConstr(4*x0 + 3*x2 + 4*x3 <= 23)
m.addConstr(4*x0 + 5*x1 + 3*x2 <= 16)
m.addConstr(4*x0 + 5*x1 + 3*x2 + 4*x3 <= 16)
m.addConstr(3*x2 + 7*x3 <= 36)
m.addConstr(4*x0 + 6*x1 <= 63)
m.addConstr(6*x1 + 7*x3 <= 47)
m.addConstr(4*x0 + 3*x2 <= 41)
m.addConstr(6*x1 + 3*x2 + 7*x3 <= 50)
m.addConstr(4*x0 + 6*x1 + 3*x2 + 7*x3 <= 50)


# Resource Constraints
m.addConstr(3*x0 <= 70)
m.addConstr(4*x0 <= 59)
m.addConstr(4*x0 <= 67)

m.addConstr(5*x1 <= 70)
m.addConstr(5*x1 <= 59)
m.addConstr(6*x1 <= 67)

m.addConstr(3*x2 <= 70)
m.addConstr(3*x2 <= 59)
m.addConstr(3*x2 <= 67)

m.addConstr(4*x3 <= 70)
m.addConstr(4*x3 <= 59)
m.addConstr(7*x3 <= 67)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

