
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="armored_companies", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(6*x0 + 3*x1 + 5*x2 + 4*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 >= 9)
m.addConstr(5*x1 + 3*x2 >= 14)
m.addConstr(4*x0 + 5*x1 >= 9)
m.addConstr(3*x2 + 4*x3 >= 9)
m.addConstr(5*x1 + 4*x3 >= 11)
m.addConstr(3*x2 + 4*x3 <= 21)
m.addConstr(3*x0 + 4*x3 <= 29)
m.addConstr(5*x1 + 4*x3 <= 22)
m.addConstr(3*x0 + 5*x1 + 3*x2 + 4*x3 <= 22)
m.addConstr(5*x1 + 4*x3 <= 17)
m.addConstr(3*x2 + 4*x3 <= 28)
m.addConstr(4*x0 + 4*x3 <= 28)
m.addConstr(4*x0 + 5*x1 <= 45)
m.addConstr(4*x0 + 3*x2 <= 55)
m.addConstr(4*x0 + 3*x2 + 4*x3 <= 23)
m.addConstr(4*x0 + 5*x1 + 3*x2 <= 16)
m.addConstr(4*x0 + 5*x1 + 3*x2 + 4*x3 <= 16)
m.addConstr(3*x2 + 7*x3 <= 36)
m.addConstr(4*x0 + 6*x1 <= 63)
m.addConstr(6*x1 + 7*x3 <= 47)
m.addConstr(4*x0 + 3*x2 <= 41)
m.addConstr(6*x1 + 3*x2 + 7*x3 <= 50)
m.addConstr(4*x0 + 6*x1 + 3*x2 + 7*x3 <= 50)

# Optimize the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("CBRN platoons: ", x0.varValue)
print("airborne infantry companies: ", x1.varValue)
print("light infantry companies: ", x2.varValue)
print("armored companies: ", x3.varValue)

# Symbolic representation
sym_variables = [('x0', 'CBRN platoons'), ('x1', 'airborne infantry companies'), ('x2', 'light infantry companies'), ('x3', 'armored companies')]
objective_function = '6*x0 + 3*x1 + 5*x2 + 4*x3'
constraints = [
    '3*x0 >= 9',
    '5*x1 + 3*x2 >= 14',
    '4*x0 + 5*x1 >= 9',
    '3*x2 + 4*x3 >= 9',
    '5*x1 + 4*x3 >= 11',
    '3*x2 + 4*x3 <= 21',
    '3*x0 + 4*x3 <= 29',
    '5*x1 + 4*x3 <= 22',
    '3*x0 + 5*x1 + 3*x2 + 4*x3 <= 22',
    '5*x1 + 4*x3 <= 17',
    '3*x2 + 4*x3 <= 28',
    '4*x0 + 4*x3 <= 28',
    '4*x0 + 5*x1 <= 45',
    '4*x0 + 3*x2 <= 55',
    '4*x0 + 3*x2 + 4*x3 <= 23',
    '4*x0 + 5*x1 + 3*x2 <= 16',
    '4*x0 + 5*x1 + 3*x2 + 4*x3 <= 16',
    '3*x2 + 7*x3 <= 36',
    '4*x0 + 6*x1 <= 63',
    '6*x1 + 7*x3 <= 47',
    '4*x0 + 3*x2 <= 41',
    '6*x1 + 3*x2 + 7*x3 <= 50',
    '4*x0 + 6*x1 + 3*x2 + 7*x3 <= 50'
]

print("\nSymbolic Representation:")
print("Variables: ", sym_variables)
print("Objective Function: ", objective_function)
print("Constraints: ", constraints)

