
from gurobipy import Model, GRB

# Create a new model
m = Model("military_optimization")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")
x3 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")


# Set objective function
m.setObjective(1*x0 + 1*x1 + 5*x2 + 7*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x0 + 12*x1 + 5*x3 >= 28)
m.addConstr(13*x2 + 8*x3 >= 14)
m.addConstr(3*x0 + 13*x2 >= 26)
m.addConstr(2*x1 + 13*x2 >= 24)
m.addConstr(3*x0 + 2*x1 + 13*x2 >= 17)
m.addConstr(3*x0 + 13*x2 + 8*x3 >= 17)
m.addConstr(2*x1 + 13*x2 + 8*x3 >= 17)
m.addConstr(3*x0 + 2*x1 + 13*x2 >= 25)
m.addConstr(3*x0 + 13*x2 + 8*x3 >= 25)
m.addConstr(2*x1 + 13*x2 + 8*x3 >= 25)
m.addConstr(3*x0 + 2*x1 + 13*x2 >= 26)
m.addConstr(3*x0 + 13*x2 + 8*x3 >= 26)
m.addConstr(2*x1 + 13*x2 + 8*x3 >= 26)
m.addConstr(17*x0 + 4*x3 >= 5)
m.addConstr(17*x0 + 9*x1 >= 14)
m.addConstr(7*x2 + 4*x3 >= 6)
m.addConstr(17*x0 + 5*x3 <= 59)
m.addConstr(12*x1 + 11*x2 <= 64)
m.addConstr(12*x1 + 5*x3 <= 103)
m.addConstr(17*x0 + 12*x1 + 11*x2 <= 51)
m.addConstr(17*x0 + 12*x1 + 11*x2 + 5*x3 <= 51)
m.addConstr(3*x0 + 2*x1 <= 64)
m.addConstr(13*x2 + 8*x3 <= 93)
m.addConstr(3*x0 + 2*x1 + 13*x2 + 8*x3 <= 93)
m.addConstr(9*x1 + 7*x2 <= 28)
m.addConstr(9*x1 + 4*x3 <= 27)
m.addConstr(17*x0 + 9*x1 <= 34)
m.addConstr(17*x0 + 4*x3 <= 34)
m.addConstr(17*x0 + 9*x1 + 7*x2 <= 28)
m.addConstr(9*x1 + 7*x2 + 4*x3 <= 26)
m.addConstr(17*x0 + 9*x1 + 4*x3 <= 28)
m.addConstr(17*x0 + 9*x1 + 7*x2 + 4*x3 <= 28)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

