
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    headsets = m.addVar(vtype=GRB.INTEGER, name="headsets")
    scissors = m.addVar(vtype=GRB.INTEGER, name="scissors")
    blue_pens = m.addVar(vtype=GRB.INTEGER, name="blue_pens")
    blue_highlighters = m.addVar(vtype=GRB.INTEGER, name="blue_highlighters")
    color_printers = m.addVar(vtype=GRB.INTEGER, name="color_printers")

    # Set objective function
    obj = 7.04*headsets**2 + 3.25*headsets*scissors + 7.47*headsets*blue_pens + 8.76*headsets*blue_highlighters + 9.02*headsets*color_printers + 1.01*scissors**2 + 6.49*scissors*blue_pens + 9.89*scissors*blue_highlighters + 9.84*blue_pens**2 + 9.76*blue_pens*color_printers + 6.46*blue_highlighters*color_printers + 7.63*scissors + 4.82*blue_pens + 4.36*color_printers


    m.setObjective(obj, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*headsets + 4*scissors + 7*blue_pens + 7*blue_highlighters + 5*color_printers <= 247, "c0")
    m.addConstr(3*headsets + 7*blue_highlighters >= 40, "c1")
    m.addConstr(4*scissors**2 + 7*blue_pens**2 >= 22, "c2")
    m.addConstr(7*blue_pens + 5*color_printers >= 28, "c3")
    m.addConstr(4*scissors + 7*blue_highlighters >= 46, "c4")
    m.addConstr(3*headsets + 5*color_printers >= 21, "c5")
    m.addConstr(7*blue_pens**2 + 7*blue_highlighters**2 >= 47, "c6")
    m.addConstr(3*headsets + 4*scissors + 7*blue_highlighters >= 44, "c7")
    m.addConstr(4*scissors + 7*blue_pens <= 194, "c8")
    m.addConstr(3*headsets**2 + 7*blue_pens**2 <= 51, "c9")
    m.addConstr(7*blue_pens**2 + 5*color_printers**2 <= 157, "c10")
    m.addConstr(4*scissors + 5*color_printers <= 91, "c11")
    m.addConstr(4*scissors + 7*blue_highlighters + 5*color_printers <= 101, "c12")
    m.addConstr(3*headsets**2 + 4*scissors**2 + 5*color_printers**2 <= 162, "c13")
    m.addConstr(3*headsets + 7*blue_pens + 5*color_printers <= 234, "c14")
    m.addConstr(7*blue_pens + 7*blue_highlighters + 5*color_printers <= 240, "c15")
    m.addConstr(3*headsets + 4*scissors + 7*blue_pens + 7*blue_highlighters + 5*color_printers <= 240, "c16")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
