
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="blue pens", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="blue highlighters", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="color printers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7.04*x1**2 + 3.25*x1*x2 + 7.47*x1*x3 + 8.76*x1*x4 + 9.02*x1*x5 + 
                      1.01*x2**2 + 6.49*x2*x3 + 9.89*x2*x4 + 9.84*x3**2 + 9.76*x3*x5 + 
                      6.46*x4*x5 + 7.63*x2 + 4.82*x3 + 4.36*x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 7*x4 >= 40)
    model.addConstr(16*x2**2 + 49*x3**2 >= 22)
    model.addConstr(7*x3 + 5*x5 >= 28)
    model.addConstr(4*x2 + 7*x4 >= 46)
    model.addConstr(3*x1 + 5*x5 >= 21)
    model.addConstr(49*x3**2 + 49*x4**2 >= 47)
    model.addConstr(3*x1 + 4*x2 + 7*x4 >= 44)
    model.addConstr(4*x2 + 7*x3 <= 194)
    model.addConstr(9*x1**2 + 49*x3**2 <= 51)
    model.addConstr(49*x3**2 + 25*x5**2 <= 157)
    model.addConstr(4*x2 + 5*x5 <= 91)
    model.addConstr(4*x2 + 7*x4 + 5*x5 <= 101)
    model.addConstr(9*x1**2 + 16*x2**2 + 25*x5**2 <= 162)
    model.addConstr(3*x1 + 7*x3 + 5*x5 <= 234)
    model.addConstr(7*x3 + 7*x4 + 5*x5 <= 240)
    model.addConstr(3*x1 + 4*x2 + 7*x3 + 7*x4 + 5*x5 <= 240)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Headsets: ", x1.varValue)
        print("Scissors: ", x2.varValue)
        print("Blue Pens: ", x3.varValue)
        print("Blue Highlighters: ", x4.varValue)
        print("Color Printers: ", x5.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
