
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    knishes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="knishes")
    sashimi = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sashimi")


    # Set objective function
    m.setObjective(3.68 * knishes + 3.44 * sashimi, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * knishes + 6 * sashimi >= 49, "umami_lower_bound")
    m.addConstr(1 * knishes + 4 * sashimi >= 68, "healthiness_lower_bound")
    m.addConstr(4 * knishes - 5 * sashimi >= 0, "knishes_sashimi_relation")
    m.addConstr(3 * knishes + 6 * sashimi <= 84, "umami_upper_bound")
    m.addConstr(1 * knishes + 4 * sashimi <= 165, "healthiness_upper_bound")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("knishes:", knishes.x)
        print("sashimi:", sashimi.x)

except gp.GrorbiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

