
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="knishes")
x2 = m.addVar(lb=0, name="sashimi")

# Set the objective function
m.setObjective(3.68*x1 + 3.44*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 6*x2 >= 49, "umami_index_lower")
m.addConstr(1*x1 + 4*x2 >= 68, "healthiness_rating_lower")
m.addConstr(4*x1 - 5*x2 >= 0, "mixed_constraint")
m.addConstr(3*x1 + 6*x2 <= 84, "umami_index_upper")
m.addConstr(1*x1 + 4*x2 <= 165, "healthiness_rating_upper")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Knishes: {x1.x}")
    print(f"Sashimi: {x2.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
