
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
knishes = model.addVar(name='knishes', lb=0)  # Fractional amount allowed
sashimi = model.addVar(name='sashimi', lb=0)  # Fractional amount allowed

# Define the objective function
model.setObjective(3.68 * knishes + 3.44 * sashimi, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(3 * knishes + 6 * sashimi >= 49, name='umami_index_min')
model.addConstr(knishes + 4 * sashimi >= 68, name='healthiness_rating_min')
model.addConstr(4 * knishes - 5 * sashimi >= 0, name='knishes_sashimi_mix')
model.addConstr(3 * knishes + 6 * sashimi <= 84, name='umami_index_max')
model.addConstr(knishes + 4 * sashimi <= 165, name='healthiness_rating_max')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print(f'Knishes: {knishes.varValue}')
    print(f'Sashimi: {sashimi.varValue}')
    print(f'Objective: {model.objVal}')
else:
    print('No optimal solution found.')
