
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    laura_hours = model.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")
    mary_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="mary_hours")
    ringo_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo_hours")

    # Set objective function
    model.setObjective(4 * laura_hours + 3 * mary_hours + 6 * ringo_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * mary_hours + 11 * ringo_hours >= 36, "c1")
    model.addConstr(18 * laura_hours + 10 * mary_hours >= 46, "c2")
    model.addConstr(18 * laura_hours + 10 * mary_hours + 11 * ringo_hours >= 51, "c3")
    model.addConstr(23 * mary_hours + 18 * ringo_hours >= 66, "c4")
    model.addConstr(7 * laura_hours + 23 * mary_hours >= 76, "c5")
    model.addConstr(7 * laura_hours + 18 * ringo_hours >= 79, "c6")
    model.addConstr(18 * laura_hours + 11 * ringo_hours <= 135, "c7")
    model.addConstr(18 * laura_hours + 10 * mary_hours <= 258, "c8")
    model.addConstr(18 * laura_hours + 10 * mary_hours + 11 * ringo_hours <= 196, "c9")
    model.addConstr(29 * laura_hours + 28 * ringo_hours <= 257, "c10")
    model.addConstr(29 * laura_hours + 16 * mary_hours + 28 * ringo_hours <= 257, "c11")
    model.addConstr(7 * laura_hours + 18 * ringo_hours <= 122, "c12")
    model.addConstr(23 * mary_hours + 18 * ringo_hours <= 235, "c13")
    model.addConstr(7 * laura_hours + 23 * mary_hours <= 270, "c14")
    model.addConstr(7 * laura_hours + 23 * mary_hours + 18 * ringo_hours <= 270, "c15")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Laura Hours:', laura_hours.x)
        print('Mary Hours:', mary_hours.x)
        print('Ringo Hours:', ringo_hours.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
