
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    x1 = model.addVar(name="x1")  # hours worked by Mary
    x2 = model.addVar(name="x2")  # hours worked by Ringo

    # Define the objective function
    model.setObjective(4 * x0 + 3 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 11 * x2 >= 36)
    model.addConstr(18 * x0 + 10 * x1 >= 46)
    model.addConstr(18 * x0 + 10 * x1 + 11 * x2 >= 51)
    model.addConstr(23 * x1 + 18 * x2 >= 66)
    model.addConstr(7 * x0 + 23 * x1 >= 76)
    model.addConstr(7 * x0 + 18 * x2 >= 79)
    model.addConstr(18 * x0 + 11 * x2 <= 135)
    model.addConstr(18 * x0 + 10 * x1 <= 258)
    model.addConstr(18 * x0 + 10 * x1 + 11 * x2 <= 196)
    model.addConstr(29 * x0 + 28 * x2 <= 257)
    model.addConstr(29 * x0 + 16 * x1 + 28 * x2 <= 257)
    model.addConstr(7 * x0 + 18 * x2 <= 122)
    model.addConstr(23 * x1 + 18 * x2 <= 235)
    model.addConstr(7 * x0 + 23 * x1 <= 270)
    model.addConstr(7 * x0 + 23 * x1 + 18 * x2 <= 270)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Mary: ", x1.varValue)
        print("Hours worked by Ringo: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
