
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="george_hours")
paul_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="paul_hours")
peggy_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


# Set objective function
model.setObjective(5 * george_hours + 6 * paul_hours + 5 * peggy_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2.1 * george_hours + 1.32 * peggy_hours >= 21, "c1")
model.addConstr(5.73 * paul_hours + 1.32 * peggy_hours >= 18, "c2")
model.addConstr(2.1 * george_hours + 5.73 * paul_hours + 1.32 * peggy_hours >= 14, "c3")
model.addConstr(-10 * paul_hours + 6 * peggy_hours >= 0, "c4")
model.addConstr(9 * george_hours - 4 * paul_hours >= 0, "c5")
model.addConstr(2.1 * george_hours + 5.73 * paul_hours <= 59, "c6")
model.addConstr(5.73 * paul_hours + 1.32 * peggy_hours <= 31, "c7")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Optimal solution found')
    print(f"George's hours: {george_hours.x}")
    print(f"Paul's hours: {paul_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f"Optimization ended with status {model.status}")

