
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")

# Define the objective function
m.setObjective(5*x1 + 6*x2 + 5*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr((2.1)*x1 + (1.32)*x3 >= 21, name="constraint_1")
m.addConstr((5.73)*x2 + (1.32)*x3 >= 18, name="constraint_2")
m.addConstr((2.1)*x1 + (5.73)*x2 + (1.32)*x3 >= 14, name="constraint_3")
m.addConstr(-10*x2 + 6*x3 >= 0, name="constraint_4")
m.addConstr(9*x1 - 4*x2 >= 0, name="constraint_5")
m.addConstr((2.1)*x1 + (5.73)*x2 <= 59, name="constraint_6")
m.addConstr((5.73)*x2 + (1.32)*x3 <= 31, name="constraint_7")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
    print(f"Hours worked by Peggy: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
