
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by George
x2 = m.addVar(name="x2")  # hours worked by Paul
x3 = m.addVar(name="x3")  # hours worked by Peggy

# Objective function
m.setObjective(5 * x1 + 6 * x2 + 5 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(2.1 * x1 + 1.32 * x3 >= 21)
m.addConstr(5.73 * x2 + 1.32 * x3 >= 18)
m.addConstr(2.1 * x1 + 5.73 * x2 + 1.32 * x3 >= 14)
m.addConstr(-10 * x2 + 6 * x3 >= 0)
m.addConstr(9 * x1 - 4 * x2 >= 0)
m.addConstr(2.1 * x1 + 5.73 * x2 <= 59)
m.addConstr(5.73 * x2 + 1.32 * x3 <= 31)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", x1.varValue)
    print("Hours worked by Paul: ", x2.varValue)
    print("Hours worked by Peggy: ", x3.varValue)
else:
    print("The problem is infeasible")
