
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
    oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
    granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")

    # Set objective function
    m.setObjective(4 * milkshakes + 2 * oreos + 3 * granola_bars, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.55 * milkshakes + 2.9 * oreos + 1.3 * granola_bars <= 138, "c0")
    m.addConstr(1.27 * milkshakes + 3.78 * oreos + 4.49 * granola_bars <= 196, "c1")
    m.addConstr(0.48 * milkshakes + 1.48 * oreos + 3.86 * granola_bars <= 279, "c2")
    m.addConstr(0.75 * milkshakes + 0.13 * oreos + 3.82 * granola_bars <= 143, "c3")
    m.addConstr(0.48 * milkshakes + 1.48 * oreos >= 70, "c4")
    m.addConstr(10 * milkshakes - granola_bars >= 0, "c5")
    m.addConstr(4.55 * milkshakes + 1.3 * granola_bars <= 74, "c6")
    m.addConstr(2.9 * oreos + 1.3 * granola_bars <= 92, "c7")
    m.addConstr(4.55 * milkshakes + 2.9 * oreos + 1.3 * granola_bars <= 92, "c8")
    m.addConstr(3.78 * oreos + 4.49 * granola_bars <= 157, "c9")
    m.addConstr(1.27 * milkshakes + 3.78 * oreos <= 196, "c10")
    m.addConstr(1.27 * milkshakes + 4.49 * granola_bars <= 130, "c11")
    m.addConstr(1.27 * milkshakes + 3.78 * oreos + 4.49 * granola_bars <= 130, "c12")
    m.addConstr(0.48 * milkshakes + 3.86 * granola_bars <= 164, "c13")
    m.addConstr(0.48 * milkshakes + 1.48 * oreos <= 218, "c14")
    m.addConstr(0.48 * milkshakes + 1.48 * oreos + 3.86 * granola_bars <= 218, "c15")
    m.addConstr(0.13 * oreos + 3.82 * granola_bars <= 129, "c16")
    m.addConstr(0.75 * milkshakes + 0.13 * oreos + 3.82 * granola_bars <= 129, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
