
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milkshakes", lb=0)
x1 = model.addVar(name="oreos", lb=0)
x2 = model.addVar(name="granola bars", lb=0)

# Set the objective function
model.setObjective(4 * x0 + 2 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.48 * x0 + 1.48 * x1 >= 70)
model.addConstr(10 * x0 - x2 >= 0)
model.addConstr(4.55 * x0 + 1.3 * x2 <= 74)
model.addConstr(2.9 * x1 + 1.3 * x2 <= 92)
model.addConstr(4.55 * x0 + 2.9 * x1 + 1.3 * x2 <= 92)
model.addConstr(3.78 * x1 + 4.49 * x2 <= 157)
model.addConstr(1.27 * x0 + 3.78 * x1 <= 196)
model.addConstr(1.27 * x0 + 4.49 * x2 <= 130)
model.addConstr(1.27 * x0 + 3.78 * x1 + 4.49 * x2 <= 130)
model.addConstr(0.48 * x0 + 3.86 * x2 <= 164)
model.addConstr(0.48 * x0 + 1.48 * x1 <= 218)
model.addConstr(0.48 * x0 + 1.48 * x1 + 3.86 * x2 <= 218)
model.addConstr(0.13 * x1 + 3.82 * x2 <= 129)
model.addConstr(0.75 * x0 + 0.13 * x1 + 3.82 * x2 <= 129)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Milkshakes: ", x0.varValue)
    print("Oreos: ", x1.varValue)
    print("Granola bars: ", x2.varValue)
else:
    print("The model is infeasible")
