
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
network_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")


# Set objective function
m.setObjective(4 * security_engineers + 6 * pen_testers + 5 * automatic_alerts + 7 * network_administrators + 2 * system_administrators, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * pen_testers + 22 * automatic_alerts >= 153)
m.addConstr(22 * automatic_alerts + 9 * system_administrators >= 133)
m.addConstr(2 * pen_testers + 9 * system_administrators >= 83)
m.addConstr(22 * security_engineers + 9 * system_administrators >= 92)
m.addConstr(22 * automatic_alerts + 5 * network_administrators + 9 * system_administrators >= 118)
m.addConstr(22 * security_engineers + 22 * automatic_alerts + 5 * network_administrators >= 118)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 5 * network_administrators >= 118)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 9 * system_administrators >= 118)
m.addConstr(22 * automatic_alerts + 5 * network_administrators + 9 * system_administrators >= 85)
m.addConstr(22 * security_engineers + 22 * automatic_alerts + 5 * network_administrators >= 85)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 5 * network_administrators >= 85)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 9 * system_administrators >= 85)
m.addConstr(22 * automatic_alerts + 5 * network_administrators + 9 * system_administrators >= 95)
m.addConstr(22 * security_engineers + 22 * automatic_alerts + 5 * network_administrators >= 95)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 5 * network_administrators >= 95)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 9 * system_administrators >= 95)
m.addConstr(22 * automatic_alerts + 5 * network_administrators + 9 * system_administrators >= 150)
m.addConstr(22 * security_engineers + 22 * automatic_alerts + 5 * network_administrators >= 150)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 5 * network_administrators >= 150)
m.addConstr(2 * pen_testers + 22 * automatic_alerts + 9 * system_administrators >= 150)
m.addConstr(22 * security_engineers + 2 * pen_testers + 22 * automatic_alerts + 5 * network_administrators + 9 * system_administrators >= 150)
m.addConstr(14 * automatic_alerts + 23 * network_administrators >= 51)
m.addConstr(14 * automatic_alerts + 8 * system_administrators >= 53)
m.addConstr(15 * security_engineers + 14 * automatic_alerts >= 32)
m.addConstr(22 * pen_testers + 14 * automatic_alerts >= 46)
m.addConstr(15 * security_engineers + 8 * system_administrators >= 52)
m.addConstr(22 * pen_testers + 14 * automatic_alerts + 23 * network_administrators >= 46)
m.addConstr(15 * security_engineers + 22 * pen_testers + 14 * automatic_alerts + 23 * network_administrators + 8 * system_administrators >= 46)
m.addConstr(-pen_testers + 5 * automatic_alerts >= 0)
m.addConstr(7 * security_engineers - 6 * automatic_alerts >= 0)
m.addConstr(-4 * automatic_alerts + 9 * system_administrators >= 0)
m.addConstr(22 * security_engineers + 2 * pen_testers + 9 * system_administrators <= 560)
m.addConstr(22 * security_engineers + 2 * pen_testers + 5 * network_administrators <= 343)
m.addConstr(22 * security_engineers + 22 * automatic_alerts + 9 * system_administrators <= 285)
m.addConstr(22 * security_engineers + 5 * network_administrators + 9 * system_administrators <= 263)
m.addConstr(2 * pen_testers + 5 * network_administrators + 9 * system_administrators <= 168)
m.addConstr(22 * security_engineers + 22 * automatic_alerts + 5 * network_administrators <= 670)
m.addConstr(23 * network_administrators + 8 * system_administrators <= 133)
m.addConstr(15 * security_engineers + 22 * pen_testers + 8 * system_administrators <= 381)
m.addConstr(22 * security_engineers <= 802)
m.addConstr(15 * security_engineers + 22 * pen_testers + 14 * automatic_alerts + 23 * network_administrators + 8 * system_administrators <= 403)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

