
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="automatic_alerts", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="system_administrators", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4 * x0 + 6 * x1 + 5 * x2 + 7 * x3 + 2 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(22 * x0 <= 802)
    model.addConstr(15 * x0 + 22 * x1 + 14 * x2 + 23 * x3 + 8 * x4 <= 403)
    model.addConstr(2 * x1 + 22 * x2 >= 153)
    model.addConstr(22 * x2 + 9 * x4 >= 133)
    model.addConstr(2 * x1 + 9 * x4 >= 83)
    model.addConstr(22 * x0 + 9 * x4 >= 92)
    model.addConstr(22 * x2 + 5 * x3 + 9 * x4 >= 118)
    model.addConstr(22 * x0 + 22 * x2 + 5 * x3 >= 118)
    model.addConstr(2 * x1 + 22 * x2 + 5 * x3 >= 118)
    model.addConstr(2 * x1 + 22 * x2 + 9 * x4 >= 118)
    model.addConstr(22 * x2 + 5 * x3 + 9 * x4 >= 85)
    model.addConstr(22 * x0 + 22 * x2 + 5 * x3 >= 85)
    model.addConstr(2 * x1 + 22 * x2 + 5 * x3 >= 85)
    model.addConstr(2 * x1 + 22 * x2 + 9 * x4 >= 85)
    model.addConstr(22 * x2 + 5 * x3 + 9 * x4 >= 95)
    model.addConstr(22 * x0 + 22 * x2 + 5 * x3 >= 95)
    model.addConstr(2 * x1 + 22 * x2 + 5 * x3 >= 95)
    model.addConstr(2 * x1 + 22 * x2 + 9 * x4 >= 95)
    model.addConstr(22 * x2 + 5 * x3 + 9 * x4 >= 150)
    model.addConstr(22 * x0 + 22 * x2 + 5 * x3 >= 150)
    model.addConstr(2 * x1 + 22 * x2 + 5 * x3 >= 150)
    model.addConstr(2 * x1 + 22 * x2 + 9 * x4 >= 150)
    model.addConstr(22 * x0 + 2 * x1 + 22 * x2 + 5 * x3 + 9 * x4 >= 150)
    model.addConstr(14 * x2 + 23 * x3 >= 51)
    model.addConstr(14 * x2 + 8 * x4 >= 53)
    model.addConstr(15 * x0 + 14 * x2 >= 32)
    model.addConstr(22 * x1 + 14 * x2 >= 46)
    model.addConstr(15 * x0 + 8 * x4 >= 52)
    model.addConstr(22 * x1 + 14 * x2 + 23 * x3 >= 46)
    model.addConstr(15 * x0 + 22 * x1 + 14 * x2 + 23 * x3 + 8 * x4 >= 46)
    model.addConstr(-x1 + 5 * x2 >= 0)
    model.addConstr(7 * x0 - 6 * x2 >= 0)
    model.addConstr(-4 * x2 + 9 * x4 >= 0)
    model.addConstr(22 * x0 + 2 * x1 + 9 * x4 <= 560)
    model.addConstr(22 * x0 + 2 * x1 + 5 * x3 <= 343)
    model.addConstr(22 * x0 + 22 * x2 + 9 * x4 <= 285)
    model.addConstr(22 * x0 + 5 * x3 + 9 * x4 <= 263)
    model.addConstr(2 * x1 + 5 * x3 + 9 * x4 <= 168)
    model.addConstr(22 * x0 + 22 * x2 + 5 * x3 <= 670)
    model.addConstr(23 * x3 + 8 * x4 <= 133)
    model.addConstr(15 * x0 + 22 * x1 + 8 * x4 <= 381)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Security Engineers: ", x0.varValue)
        print("Pen Testers: ", x1.varValue)
        print("Automatic Alerts: ", x2.varValue)
        print("Network Administrators: ", x3.varValue)
        print("System Administrators: ", x4.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
