
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="oreos")
    x2 = m.addVar(vtype=GRB.INTEGER, name="kiwis")


    # Set objective function
    m.setObjective(6*x0 + 8*x1 + 9*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.02*x0 + 0.69*x2 >= 17, "iron_constraint1")
    m.addConstr(0.02*x0 + 0.05*x1 + 0.69*x2 >= 17, "iron_constraint2")
    m.addConstr(0.55*x0 + 0.77*x2 >= 16, "cost_constraint1")
    m.addConstr(0.55*x0 + 0.81*x1 >= 10, "cost_constraint2")
    m.addConstr(0.55*x0 + 0.81*x1 + 0.77*x2 >= 10, "cost_constraint3")
    m.addConstr(6*x0 - 5*x1 >= 0, "constraint4")
    m.addConstr(6*x0 - 3*x2 >= 0, "constraint5")
    m.addConstr(0.02*x0 + 0.69*x2 <= 38, "constraint6")

    # Resource Constraints
    m.addConstr(0.02*x0 <= 55, "iron_limit_x0")
    m.addConstr(0.05*x1 <= 55, "iron_limit_x1")
    m.addConstr(0.69*x2 <= 55, "iron_limit_x2")
    m.addConstr(0.55*x0 <= 88, "cost_limit_x0")
    m.addConstr(0.81*x1 <= 88, "cost_limit_x1")
    m.addConstr(0.77*x2 <= 88, "cost_limit_x2")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
