
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="protein_bars", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(name="oreos", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6*x0 + 8*x1 + 9*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.02*x0 + 0.05*x1 + 0.69*x2 <= 55)
    model.addConstr(0.55*x0 + 0.81*x1 + 0.77*x2 <= 88)
    model.addConstr(0.02*x0 + 0.69*x2 >= 17)
    model.addConstr(0.02*x0 + 0.05*x1 + 0.69*x2 >= 17)
    model.addConstr(0.55*x0 + 0.77*x2 >= 16)
    model.addConstr(0.55*x0 + 0.81*x1 >= 10)
    model.addConstr(0.55*x0 + 0.81*x1 + 0.77*x2 >= 10)
    model.addConstr(6*x0 - 5*x1 >= 0)
    model.addConstr(6*x0 - 3*x2 >= 0)
    model.addConstr(0.02*x0 + 0.69*x2 <= 38)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Protein bars: ", x0.varValue)
        print("Oreos: ", x1.varValue)
        print("Kiwis: ", x2.varValue)
    else:
        print("Model is infeasible")

solve_optimization_problem()
