
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
vincas = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")
carnations = m.addVar(vtype=gp.GRB.INTEGER, name="carnations")
orange_trees = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")
bean_stalks = m.addVar(vtype=gp.GRB.INTEGER, name="bean_stalks")

# Set objective function
m.setObjective(3.53 * vincas + 8.78 * carnations + 7.88 * orange_trees + 1.34 * bean_stalks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * vincas + 20 * orange_trees >= 29)
m.addConstr(21 * vincas + 17 * carnations >= 42)
m.addConstr(17 * carnations + 25 * bean_stalks >= 33)
m.addConstr(17 * carnations + 20 * orange_trees + 25 * bean_stalks >= 41)
m.addConstr(21 * vincas + 17 * carnations + 25 * bean_stalks >= 41)
m.addConstr(17 * carnations + 20 * orange_trees + 25 * bean_stalks >= 68)
m.addConstr(21 * vincas + 17 * carnations + 25 * bean_stalks >= 68)
m.addConstr(carnations + 23 * bean_stalks >= 78)
m.addConstr(5 * vincas + 23 * bean_stalks >= 54)
m.addConstr(5 * vincas + carnations >= 54)
m.addConstr(carnations + 26 * orange_trees >= 56)
m.addConstr(5 * vincas + carnations + 23 * bean_stalks >= 70)
m.addConstr(carnations + 26 * orange_trees + 23 * bean_stalks >= 70)
m.addConstr(5 * vincas + carnations + 26 * orange_trees >= 70)
m.addConstr(5 * vincas + carnations + 23 * bean_stalks >= 82)
m.addConstr(carnations + 26 * orange_trees + 23 * bean_stalks >= 82)
m.addConstr(5 * vincas + carnations + 26 * orange_trees >= 82)
m.addConstr(5 * vincas + carnations + 23 * bean_stalks >= 59)
m.addConstr(carnations + 26 * orange_trees + 23 * bean_stalks >= 59)
m.addConstr(5 * vincas + carnations + 26 * orange_trees >= 59)
m.addConstr(-5 * vincas + 6 * carnations >= 0)
m.addConstr(21 * vincas + 20 * orange_trees <= 172)
m.addConstr(21 * vincas + 17 * carnations <= 133)
m.addConstr(21 * vincas + 17 * carnations + 20 * orange_trees + 25 * bean_stalks <= 133)
m.addConstr(5 * vincas + 26 * orange_trees <= 288)
m.addConstr(carnations + 23 * bean_stalks <= 205)
m.addConstr(carnations + 26 * orange_trees <= 169)
m.addConstr(26 * orange_trees + 23 * bean_stalks <= 227)
m.addConstr(carnations + 26 * orange_trees + 23 * bean_stalks <= 218)
m.addConstr(5 * vincas + carnations + 26 * orange_trees <= 364)
m.addConstr(5 * vincas + carnations + 26 * orange_trees + 23 * bean_stalks <= 364)

# Resource constraints
m.addConstr(21 * vincas + 17 * carnations + 20 * orange_trees + 25 * bean_stalks <= 313)
m.addConstr(5 * vincas + carnations + 26 * orange_trees + 23 * bean_stalks <= 461)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

