
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='vincas', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='carnations', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='orange trees', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='bean stalks', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(3.53*x1 + 8.78*x2 + 7.88*x3 + 1.34*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21*x1 <= 313)
m.addConstr(5*x1 + x2 + 26*x3 + 23*x4 <= 461)
m.addConstr(21*x1 + 20*x3 >= 29)
m.addConstr(21*x1 + 17*x2 >= 42)
m.addConstr(17*x2 + 25*x4 >= 33)
m.addConstr(17*x2 + 20*x3 + 25*x4 >= 41)
m.addConstr(21*x1 + 17*x2 + 25*x4 >= 41)
m.addConstr(17*x2 + 20*x3 + 25*x4 >= 68)
m.addConstr(21*x1 + 17*x2 + 25*x4 >= 68)
m.addConstr(x2 + 23*x4 >= 78)
m.addConstr(5*x1 + 23*x4 >= 54)
m.addConstr(5*x1 + x2 >= 54)
m.addConstr(x2 + 26*x3 >= 56)
m.addConstr(5*x1 + x2 + 23*x4 >= 70)
m.addConstr(x2 + 26*x3 + 23*x4 >= 70)
m.addConstr(5*x1 + x2 + 26*x3 >= 70)
m.addConstr(5*x1 + x2 + 23*x4 >= 82)
m.addConstr(x2 + 26*x3 + 23*x4 >= 82)
m.addConstr(5*x1 + x2 + 26*x3 >= 82)
m.addConstr(5*x1 + x2 + 23*x4 >= 59)
m.addConstr(x2 + 26*x3 + 23*x4 >= 59)
m.addConstr(5*x1 + x2 + 26*x3 >= 59)
m.addConstr(-5*x1 + 6*x2 >= 0)
m.addConstr(21*x1 + 20*x3 <= 172)
m.addConstr(21*x1 + 17*x2 <= 133)
m.addConstr(21*x1 + 17*x2 + 20*x3 + 25*x4 <= 133)
m.addConstr(5*x1 + 26*x3 <= 288)
m.addConstr(x2 + 23*x4 <= 205)
m.addConstr(x2 + 26*x3 <= 169)
m.addConstr(26*x3 + 23*x4 <= 227)
m.addConstr(x2 + 26*x3 + 23*x4 <= 218)
m.addConstr(5*x1 + x2 + 26*x3 <= 364)
m.addConstr(5*x1 + x2 + 26*x3 + 23*x4 <= 364)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Vincas: ', x1.varValue)
    print('Carnations: ', x2.varValue)
    print('Orange Trees: ', x3.varValue)
    print('Bean Stalks: ', x4.varValue)
else:
    print('No solution found')
