
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    ringo = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo")
    bobby = model.addVar(lb=0, vtype=GRB.INTEGER, name="bobby")
    jean = model.addVar(lb=0, vtype=GRB.INTEGER, name="jean")

    # Set objective function
    model.setObjective(8.79*ringo**2 + 8.32*ringo*bobby + 3.36*bobby**2 + 1.92*bobby*jean + 7.38*jean**2 + 7.99*ringo + 4.63*bobby + 6.45*jean, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4.53*ringo**2 + 10.63*bobby**2 >= 28, "c1")
    model.addConstr(4.53*ringo + 11.55*jean >= 28, "c2")
    model.addConstr(1.66*ringo + 11.7*jean >= 33, "c3")
    model.addConstr(1.66*ringo**2 + 6.57*bobby**2 + 11.7*jean**2 >= 40, "c4")
    model.addConstr(10.63*bobby + 11.55*jean <= 60, "c5")
    model.addConstr(4.53*ringo**2 + 11.55*jean**2 <= 87, "c6")
    model.addConstr(4.53*ringo + 10.63*bobby + 11.55*jean <= 87, "c7")
    model.addConstr(1.66*ringo**2 + 6.57*bobby**2 <= 119, "c8")
    model.addConstr(1.66*ringo + 11.7*jean <= 137, "c9")
    model.addConstr(1.66*ringo + 6.57*bobby + 11.7*jean <= 70, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Ringo:', ringo.x)
        print('Bobby:', bobby.x)
        print('Jean:', jean.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
