
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8.79*x0**2 + 8.32*x0*x1 + 3.36*x1**2 + 1.92*x1*x2 + 7.38*x2**2 + 7.99*x0 + 4.63*x1 + 6.45*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4.53*x0 <= 128)
    model.addConstr(1.66*x0 <= 141)
    model.addConstr(10.63*x1 <= 128)
    model.addConstr(6.57*x1 <= 141)
    model.addConstr(11.55*x2 <= 128)
    model.addConstr(11.7*x2 <= 141)
    model.addConstr(4.53*x0**2 + 10.63*x1**2 >= 28)
    model.addConstr(4.53*x0 + 11.55*x2 >= 28)
    model.addConstr(1.66*x0 + 11.7*x2 >= 33)
    model.addConstr(1.66*x0**2 + 6.57*x1**2 + 11.7*x2**2 >= 40)
    model.addConstr(10.63*x1 + 11.55*x2 <= 60)
    model.addConstr(4.53*x0**2 + 11.55*x2**2 <= 87)
    model.addConstr(4.53*x0 + 10.63*x1 + 11.55*x2 <= 87)
    model.addConstr(1.66*x0**2 + 6.57*x1**2 <= 119)
    model.addConstr(1.66*x0 + 11.7*x2 <= 137)
    model.addConstr(1.66*x0 + 6.57*x1 + 11.7*x2 <= 70)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("No solution found")

optimize_problem()
