
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # grams of protein
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B12
    x2 = model.addVar(name="x2", lb=0)  # grams of carbohydrates

    # Objective function
    model.setObjective(5.44 * x0 + 7.36 * x1 + 9.87 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12 * x0 <= 294)
    model.addConstr(7 * x0 <= 248)
    model.addConstr(7 * x0 <= 115)
    model.addConstr(12 * x1 <= 294)
    model.addConstr(16 * x1 <= 248)
    model.addConstr(23 * x1 <= 115)
    model.addConstr(24 * x2 <= 294)
    model.addConstr(8 * x2 <= 248)
    model.addConstr(21 * x2 <= 115)
    model.addConstr(12 * x0 + 12 * x1 >= 64)
    model.addConstr(12 * x0 + 12 * x1 + 24 * x2 >= 64)
    model.addConstr(7 * x0 + 8 * x2 >= 57)
    model.addConstr(16 * x1 + 8 * x2 >= 57)
    model.addConstr(7 * x0 + 16 * x1 + 8 * x2 >= 57)
    model.addConstr(23 * x1 + 21 * x2 >= 27)
    model.addConstr(7 * x0 + 23 * x1 >= 20)
    model.addConstr(7 * x0 + 21 * x2 >= 14)
    model.addConstr(7 * x0 + 23 * x1 + 21 * x2 >= 38)
    model.addConstr(9 * x1 - 6 * x2 >= 0)
    model.addConstr(12 * x0 + 12 * x1 <= 176)
    model.addConstr(12 * x1 + 24 * x2 <= 256)
    model.addConstr(12 * x0 + 24 * x2 <= 149)
    model.addConstr(7 * x0 + 23 * x1 <= 75)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objval}")
        print(f"Grams of protein: {x0.x}")
        print(f"Milligrams of vitamin B12: {x1.x}")
        print(f"Grams of carbohydrates: {x2.x}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
