
import gurobipy as gp

# Create a new model
model = gp.Model("minimize_likelihood_to_quit")

# Create variables
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
peggy = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy")
john = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="john")
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
dale = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale")
ringo = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo")

# Set objective function
model.setObjective(6*bobby + 4*peggy + 1*john + 8*george + 7*dale + 8*ringo, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(19.71*bobby + 8.86*ringo >= 33)
model.addConstr(8.35*john + 3.51*dale >= 19)
model.addConstr(0.29*peggy + 3.51*dale >= 40)
model.addConstr(0.29*peggy + 8.86*ringo >= 22)
model.addConstr(19.71*bobby + 3.51*dale >= 30)
model.addConstr(8.35*john + 8.86*ringo >= 30)
model.addConstr(19.71*bobby + 3.51*dale + 8.86*ringo >= 32)
model.addConstr(0.29*peggy + 8.35*john + 3.51*dale >= 32)
model.addConstr(8.35*john + 3.51*dale + 8.86*ringo >= 32)
model.addConstr(8.35*john + 13.53*george + 8.86*ringo >= 32)
model.addConstr(19.71*bobby + 8.35*john + 13.53*george >= 32)
model.addConstr(13.53*george + 3.51*dale + 8.86*ringo >= 32)
model.addConstr(8.35*john + 13.53*george + 3.51*dale >= 32)
model.addConstr(19.71*bobby + 0.29*peggy + 8.86*ringo >= 32)
model.addConstr(19.71*bobby + 13.53*george + 8.86*ringo >= 32)
model.addConstr(0.29*peggy + 3.51*dale + 8.86*ringo >= 32)
model.addConstr(0.29*peggy + 8.35*john + 8.86*ringo >= 32)
model.addConstr(19.71*bobby + 0.29*peggy + 8.35*john >= 32)
model.addConstr(19.71*bobby + 8.35*john + 3.51*dale >= 32)


model.addConstr(8.35 * john + 3.51 * dale <= 198)
model.addConstr(19.71 * bobby + 8.86 * ringo <= 211)
model.addConstr(19.71 * bobby + 8.35 * john + 8.86 * ringo <= 152)
model.addConstr(8.35 * john + 13.53 * george + 3.51 * dale <= 112)
model.addConstr(13.53 * george + 3.51 * dale + 8.86 * ringo <= 228)
model.addConstr(19.71 * bobby + 0.29 * peggy + 8.86 * ringo <= 217)
model.addConstr(19.71 * bobby + 3.51 * dale + 8.86 * ringo <= 53)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
