
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(name="x0")  # hours worked by Peggy
    x1 = model.addVar(name="x1")  # hours worked by Bill
    x2 = model.addVar(name="x2")  # hours worked by Paul


    # Set objective function
    model.setObjective(6*x0**2 + 9*x0*x1 + 2*x2**2 + x0, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1*x0**2 + 3*x1**2 >= 29, "c1")
    model.addConstr(1*x0 + 15*x2 >= 23, "c2")
    model.addConstr(1*x0 + 3*x1 + 15*x2 >= 23, "c3")
    model.addConstr(8*x0 + 16*x2 >= 25, "c4")
    model.addConstr(8*x0 + 2*x1 + 16*x2 >= 25, "c5")
    model.addConstr(5*x0**2 - 4*x2**2 >= 0, "c6")
    model.addConstr(7*x0 - 10*x1 >= 0, "c7")
    model.addConstr(8*x0**2 + 2*x1**2 <= 108, "c8")
    model.addConstr(2*x1 + 16*x2 <= 86, "c9")
    model.addConstr(1*x0 + 3*x1 + 15*x2 <= 156, "c10") # computer competence
    model.addConstr(8*x0 + 2*x1 + 16*x2 <= 137, "c11") # work quality


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
