
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Peggy
x1 = m.addVar(name="x1", lb=0)  # hours worked by Bill
x2 = m.addVar(name="x2", lb=0)  # hours worked by Paul

# Define the objective function
m.setObjective(6 * x0**2 + 9 * x0 * x1 + 2 * x2**2 + x0, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(x0**2 + x1**2 >= 29)
m.addConstr(x0 + x2 >= 23)
m.addConstr(x0 + x1 + x2 >= 23)
m.addConstr(8 * x0 + 16 * x2 >= 25)
m.addConstr(8 * x0 + 2 * x1 + 16 * x2 >= 25)
m.addConstr(5 * x0**2 - 4 * x2**2 >= 0)
m.addConstr(7 * x0 - 10 * x1 >= 0)
m.addConstr(8 * x0**2 + 2 * x1**2 <= 108)
m.addConstr(2 * x1 + 16 * x2 <= 86)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Peggy: {x0.varValue}")
    print(f"Hours worked by Bill: {x1.varValue}")
    print(f"Hours worked by Paul: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
