
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")
bagged_salads = m.addVar(vtype=gp.GRB.INTEGER, name="bagged_salads")
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches")


# Set objective function
m.setObjective(2.58 * oreos + 8.22 * bagged_salads + 5.51 * peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * oreos + 6 * bagged_salads + 3 * peanutbutter_sandwiches <= 90, "total_iron")
m.addConstr(6 * bagged_salads + 3 * peanutbutter_sandwiches <= 180, "iron_from_salads_and_sandwiches")
m.addConstr(11 * oreos + 3 * peanutbutter_sandwiches <= 75, "iron_from_oreos_and_sandwiches")
m.addConstr(11 * oreos + 6 * bagged_salads <= 90, "iron_from_oreos_and_salads")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Oreos:', oreos.x)
    print('Bagged Salads:', bagged_salads.x)
    print('Peanutbutter Sandwiches:', peanutbutter_sandwiches.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

