
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="oreos")
x2 = m.addVar(vtype=GRB.INTEGER, name="bagged_salads")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set the objective function
m.setObjective(2.58*x1 + 8.22*x2 + 5.51*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x1 + 6*x2 + 3*x3 <= 90, name="total_iron_constraint")
m.addConstr(6*x2 + 3*x3 <= 180, name="salads_sandwiches_iron_constraint")
m.addConstr(11*x1 + 3*x3 <= 75, name="oreos_sandwiches_iron_constraint")
m.addConstr(11*x1 + 6*x2 <= 90, name="oreos_salads_iron_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oreos: {x1.x}")
    print(f"Bagged Salads: {x2.x}")
    print(f"Peanutbutter Sandwiches: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
