
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    oreos = model.addVar(name="oreos", vtype=gurobi.GRB.INTEGER)
    bagged_salads = model.addVar(name="bagged_salads", vtype=gurobi.GRB.INTEGER)
    peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches")

    # Objective function
    model.setObjective(2.58 * oreos + 8.22 * bagged_salads + 5.51 * peanutbutter_sandwiches, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * bagged_salads + 3 * peanutbutter_sandwiches <= 180)
    model.addConstr(11 * oreos + 3 * peanutbutter_sandwiches <= 75)
    model.addConstr(11 * oreos + 6 * bagged_salads <= 90)
    model.addConstr(11 * oreos + 6 * bagged_salads + 3 * peanutbutter_sandwiches <= 186)

    # Non-negativity constraints
    oreos.lb = 0
    bagged_salads.lb = 0
    peanutbutter_sandwiches.lb = 0

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Oreos: ", oreos.x)
        print("Bagged Salads: ", bagged_salads.x)
        print("Peanutbutter Sandwiches: ", peanutbutter_sandwiches.x)
    else:
        print("The model is infeasible")

solve_optimization_problem()
